% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable.R
\name{as_FlexTable}
\alias{as_FlexTable}
\alias{as_flextable}
\alias{as_flextable.huxtable}
\title{Convert a huxtable for Word/Powerpoint}
\usage{
as_FlexTable(x, ...)

as_flextable(x, ...)

\method{as_flextable}{huxtable}(x, colnames_to_header = FALSE, ...)
}
\arguments{
\item{x}{A huxtable.}

\item{...}{Not used.}

\item{colnames_to_header}{Use huxtable column names as the header. If \code{FALSE}, the flextable
will contain only a body and no header.}
}
\value{
an object of class flextable.
}
\description{
Huxtables can be converted to \code{\link[flextable:flextable]{flextable::flextable()}} objects, for use in Word and Powerpoint documents.
}
\details{
With recent versions of "flextable" and Pandoc, huxtables can be automatically outputted
from rmarkdown \code{word_document} and/or \code{powerpoint_presentation} documents. (Powerpoint
presentations require pandoc version >= 2.4.0.)

\code{as_FlexTable} is deprecated and calls \code{as_flextable} with a warning.

Properties are supported, with the following exceptions:
\itemize{
\item Rotation of 0, 90 or 270 is supported.
\item Non-numeric column widths and row heights are not supported.
\item Table height, wrap, captions and table position are not supported.
\item Border style "double" is not supported and becomes "solid".
}
}
\section{Challenge}{


Try to say \code{as_flextable.huxtable} ten times without pausing.
}

\examples{
ht <- hux(a = 1:3, b = 1:3)
ft <- as_flextable(ht)
\dontrun{
  my_doc <- officer::read_docx()
  my_doc <- flextable::body_add_flextable(
        my_doc, ft)
  print(my_doc, target =
        "path/to/my_doc.docx")
}
}
