% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-table.R
\name{label}
\alias{label}
\alias{label<-}
\alias{set_label}
\title{Set a table label for external referencing}
\usage{
label(ht)
label(ht) <- value
set_label(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A string. Set to \code{NA} to reset to the default, which is
\code{"NA"}.}
}
\value{
\code{label()} returns the \code{label} property.
\code{set_label()} returns the modified huxtable.
}
\description{
The label is used as the table's label in LaTeX, and as the "id" property
of the table element in HTML.
}
\details{
LaTeX table labels typically start with \code{"tab:"}.

Within knitr, huxtable labels will default to the same as the knitr chunk label.
To turn off this behaviour, set \code{options(huxtable.autolabel = FALSE)}.

If you use \href{https://bookdown.org}{bookdown}, and set a label on your
table, the table \code{\link[=caption]{caption()}} will automatically be prefixed with \verb{(#label)}.
You can then refer to the table using \verb{@ref(label)}. \code{label} needs to start
with \code{"tab:"}; if it doesn't, the \code{"tab:"} prefix will be added
automatically. To turn off this behaviour, set
\code{options(huxtable.bookdown = FALSE)}.
}
\examples{

label(jams) <-  "tab:mytable"
label(jams)
}
\seealso{
huxtable-options
}
