% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theo.R
\name{hwelike}
\alias{hwelike}
\title{Maximum likelihood approach for equilibrium testing and double reduction
estimation.}
\usage{
hwelike(nvec, thresh = 5, effdf = FALSE)
}
\arguments{
\item{nvec}{A vector containing the observed genotype counts,
where \code{nvec[[i]]} is the number of individuals with genotype
\code{i-1}. This should be of length \code{ploidy+1}.}

\item{thresh}{The threshold for ignoring the genotype. We keep
genotypes such that \code{nvec >= thresh}.
Setting this to \code{0} uses all genotypes.}

\item{effdf}{A logical. Should we use the ad-hoc
"effective degrees of freedom" (\code{TRUE}) or not (\code{FALSE})?}
}
\value{
A list with some or all of the following elements:
\describe{
\item{\code{alpha}}{The estimated double reduction parameter(s).
In diploids, this value is \code{NULL}.}
\item{\code{r}}{The estimated allele frequency.}
\item{\code{chisq_hwe}}{The chi-square test statistic for testing
against the null of equilibrium.}
\item{\code{df_hwe}}{The degrees of freedom associated with
\code{chisq_hwe}.}
\item{\code{p_hwe}}{The p-value against the null of equilibrium.}
}
}
\description{
Genotype frequencies from Huang et al (2019) are used to implement a
likelihood procedure to estimate double reduction rates and to test
for equilibrium while accounting for double reduction. This approach
is only implemented for ploidies 4, 6, 8, and 10.
}
\examples{
thout <- hwefreq(alpha = 0.1, r = 0.3, ploidy = 6)
nvec <- c(stats::rmultinom(n = 1, size = 100, prob = thout))
hwelike(nvec = nvec)

}
\references{
\itemize{
\item{Huang, K., Wang, T., Dunn, D. W., Zhang, P., Cao, X., Liu, R., & Li, B. (2019). Genotypic frequencies at equilibrium for polysomic inheritance under double-reduction. G3: Genes, Genomes, Genetics, 9(5), 1693-1706. \doi{10.1534/g3.119.400132}}
}
}
\author{
David Gerard
}
