% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EVA.R
\name{EVA}
\alias{EVA}
\title{Evaluating main and interaction effects\cr}
\usage{
EVA(
  X,
  y,
  heredity = "Strong",
  r1,
  sigma,
  varind = NULL,
  interaction.ind = NULL,
  lambda = 10
)
}
\arguments{
\item{X}{Input data. An optional data frame, or numeric matrix of dimension
\code{n} observations by \code{p} main effects.}

\item{y}{Response variable. A \code{n}-dimensional vector.}

\item{heredity}{Whether to enforce Strong, Weak, or No heredity. Default is "Strong".}

\item{r1}{At most how many main effects do you want to include in your model?.
For high-dimensional data, \code{r1} cannot be larger than the number of screened main effects.}

\item{sigma}{The standard deviation of the noise term. In practice, sigma is usually
unknown. Users can estimate sigma from function \code{selectiveInference::estimateSigma},
then use the output as the sigma value.}

\item{varind}{A numeric vector that specifies the indices of variables to be extracted from \code{X}.
Default is "No".}

\item{interaction.ind}{A two-column numeric matrix. Each row represents a unique
interaction pair, with the columns indicating the index numbers of the variables
involved in each interaction. Note that interaction.ind must be generated
outside of this function using \code{t(utils::combn(p,2))}. See Example section for
details.}

\item{lambda}{A numeric value defined by users. The number needs to satisfy the condition:
\eqn{\lambda\geq 5.1/log(2)}. Default is 10.}
}
\value{
A list of output. The components are: ranked main effect, \code{ranked.mainpool};
and a 4-column matrix contains potential interactions ranked by ABC score, \code{ranked.intermat}.
}
\description{
This function ranks each main and interaction effect. It also calculate the ABC
score for each potential interactions across different heredity structures.
If \code{heredity = "No"} and the the number of potential interactions exceed
\code{choose(1000,2)}, distance correlation between each variable in \code{X}
and \code{y} will be calculated so that it reduces the running time.
This ensures a more efficient evaluation process.
}
\examples{
# Strong heredity
set.seed(0)
interaction.ind <- t(combn(10,2))
X <- matrix(rnorm(100*10,1,0.1), 100, 10)
epl <- rnorm(100,0,0.01)
y <- 1+X[,1]+X[,2]+X[,3]+X[,1]*X[,2]+X[,1]*X[,3]+epl
EVAoutput <- EVA(X, y, r1 = 5, sigma = 0.01, interaction.ind = interaction.ind)
}
\seealso{
\code{\link{ABC}}, \code{\link{Extract}}
}
