% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ncdf.R
\name{writeNcdf}
\alias{writeNcdf}
\title{Write to NetCDF file using hyfo list file}
\usage{
writeNcdf(gridData, filePath, missingValue = 1e+20, tz = "GMT",
  units = NULL)
}
\arguments{
\item{gridData}{A hyfo list file or the list file from \code{loadECOMS{ecomsUDG.Raccess}}
or \code{loadGridData{ecomsUDG.Raccess}}}

\item{filePath}{A path of the new NetCDF file, should end with ".nc"}

\item{missingValue}{A number representing the missing value in the NetCDF file, default
is 1e20
#'}

\item{tz}{A string representing the time zone, default is GMT, if you know what time zone is
you can assign it in the argument. If \code{tz = ''}, current time zone will be taken.}

\item{units}{A string showing in which unit you are putting in the NetCDF file, it can be
seconds or days and so on. If not specified, the function will pick up the possible largest
time units from \code{c('weeks', 'days', 'hours', 'mins', 'secs')}}
}
\value{
An NetCDF version 3 file.
}
\description{
Write to NetCDF file using hyfo list file
}
\examples{
# First open the test NETcDF file.
filePath <- system.file("extdata", "tnc.nc", package = "hyfo")


# Then if you don't know the variable name, you can use \\code{getNcdfVar} to get variable name
varname <- getNcdfVar(filePath)

nc <- loadNcdf(filePath, varname)

# Then write to your work directory

writeNcdf(nc, 'test.nc')

# More examples can be found in the user manual on http://yuanchao-xu.github.io/hyfo/
}
\references{
\itemize{
\item #' David Pierce (2014). ncdf: Interface to Unidata netCDF data files. R package version 1.6.8.
http://CRAN.R-project.org/package=ncdf

\item Santander MetGroup (2015). ecomsUDG.Raccess: R interface to the ECOMS User Data Gateway. R package
version 2.2-6. http://meteo.unican.es/ecoms-udg

}
}

