\name{volleyball}
\alias{volleyball}
\alias{vb}
\alias{volleyball_results}
\alias{volleyball_maxp}
\alias{volleyball_table}
\alias{volleyball_matrix}
\alias{vb_synthetic}
\docType{data}
\title{Results from the NOCS volleyball league}
\description{
  
Results from the \acronym{NOCS} volleyball league.  Object
\code{volleyball_table} is a matrix in which each column corresponds to
a player and each row corresponds to a volleyball set; \code{volleyball}
is the corresponding likelihood function in the form of a \code{hyper2}
distribution.

}
\usage{data(volleyball)}

\details{
A volleyball \dfn{set} is a Bernoulli trial between two disjoint subsets of
the players.  The two subsets are denoted (after the game) as the
\dQuote{winners} and the \dQuote{losers}: these are denoted by \code{1}
and \code{0} respectively.

Thus the first line reads of \code{volleyball_results} reads:
\preformatted{
 p1  p2  p3  p4  p5  p6  p7  p8  p9 
 1    0  NA   1   0   0  NA   1  NA
}

showing that the teams were \code{p1}, \code{p4} and \code{p8} against
\code{p2}, \code{p5} and \code{p6}; players \code{p3}, \code{p7} and
\code{p9} did not play.

These datasets illustrate the fact that such Bernoulli trials are only
weakly informative.  

These objects can be generated by running script
\code{inst/volleyball.Rmd}, which includes some further discussion and
technical documentation and creates file \code{volleyball.rda} which
resides in the \code{data/} directory.

}
\source{
 Volleyball games at \acronym{NOCS}, 2006-2008
}
\references{
  Robin K. S. Hankin (2010).
  \dQuote{A Generalization of the Dirichlet Distribution},
  \emph{Journal of Statistical Software}, 33(11), 1-18
}
\examples{

volleyball == volley(volleyball_table)  # should be TRUE


}
\keyword{datasets}
