\name{volvo}
\alias{volvo}
\alias{volvo_ocean_race}
\alias{volvo_table_2014}
\alias{volvo2014}
\alias{volvo_table}
\alias{volvo_maxp}
\docType{data}
\title{Race results from the 2014-2015 Volvo Ocean Race}
\description{Race results from the twelfth edition of the
  round-the-world Volvo Ocean Race.}
\usage{data(volvo)}
\format{A \code{hyper2} object that gives a likelihood function}
\details{

Object \code{volvo} is a \code{hyper2} object that gives a likelihood
function for the strengths of the competitors of the 2014-2015 Volvo
Ocean Race; \code{volvo_maxp} is a precomputed maximum likelihood
estimate of the competitors' strengths.  Object \code{volvo_table} is a
data frame with rows being teams and columns being legs.

These objects can be generated by running script \code{inst/volvo.Rmd},
which includes some further discussion and technical documentation and
creates file \code{volvo.rda} which resides in the \code{data/}
directory.

}
\references{
Wikipedia contributors, 2019.
\dQuote{2014-2015 Volvo Ocean Race}.  In \emph{Wikipedia, the free encyclopedia}.
Retrieved 22:21, February 28, 2020.
\url{https://en.wikipedia.org/w/index.php?title=2014\%E2\%80\%932015_Volvo_Ocean_Race&oldid=914916131},

}
\seealso{\code{\link{ordertable2supp}}}
\examples{
pie(volvo_maxp)
# equalp.test(volvo)   # takes ~10 seconds to run

# convert table to a support function:
rank_likelihood(wikitable_to_ranktable(volvo_table))


}
