% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.spe.R
\name{read.spe.xml}
\alias{read.spe.xml}
\title{Read XML footer from SPE file format version 3.0}
\usage{
read.spe.xml(filename, as.xml.object = require(XML), stop.if.old.fmt = TRUE)
}
\arguments{
\item{filename}{- SPE filename}

\item{as.xml.object}{- whether the result should be a pretty-printed XML object. Requires
package \code{XML}.}

\item{stop.if.old.fmt}{- determines behavior when file does not
contain XML footer. By default throws error message}
}
\value{
xml data from the file. If package XML package is available, a pretty-printed XML object is returned
}
\description{
The new SPE file format, introduced in 2012, was designed to be backwards compatible with the
previous format 2.5. The most prominent change is the new plain text XML footer holding vast
experimental metadata that gets attached at the end of the file. Thus, the file contains 3
blocks: a 4100-bytes long binary header, a chunk with spectral data, and the XML footer.
This function retrieves the XML footer, if it is available, and by default throws error otherwise.
}
