% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyreg2.R
\name{get_stv}
\alias{get_stv}
\title{extract parameter estimates as named vector}
\usage{
get_stv(mod, comp = "Comp.1")
}
\arguments{
\item{mod}{\code{model}output from \link{hyreg2} oder \link{hyreg2_het}. If \code{latent} was \code{"cont"} or \code{"dich"} only one element of the output list can be used.}

\item{comp}{\code{charachter}, default \code{"Comp.1"}. \code{"Comp.x"} indicating values from which model \code{component} (\code{x}) should be exported}
}
\value{
\verb{named vector} of parameter estimates from \code{mod}. Can be used as \code{stv} for additional model estimations using
\code{hyreg2} or \code{hyreg2_het}
}
\description{
function to export coefficient values and names from a \code{model} fitted by \code{hyreg2} or \code{hyreg2_het}
These values can be used as \code{stv} for a new model with \code{k > 1}
}
\examples{
formula <- y ~  -1 + x1 + x2 + x3 | id

k <- 1
stv <- setNames(c(0.2,0,1,1,1),c(colnames(simulated_data_norm)[3:5],c("sigma","theta")))
control = list(iter.max = 1000, verbose = 4)
rm(counter)
mod <- hyreg2(formula = formula,
                    data =  simulated_data_norm,
                    type =  simulated_data_norm$type,
                    stv = stv,
                    k = k,
                    type_cont = "TTO",
                    type_dich = "DCE_A",
                    opt_method = "L-BFGS-B",
                    control = control,
                    latent = "both",
                    id_col = "id"
)
new_stv <- get_stv(mod)

# these new_stv can be used in an other estimation using hyreg2 as stv
}
\author{
Svenja Elkenkamp
}
