\name{hzar.make.dataGroup}
\alias{hzar.make.dataGroup}
\alias{hzar.dataGroup}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Make a \code{hzar.dataGroup} object with given parameters.
}
\description{
  Make a \code{hzar.dataGroup} object with given parameters.  This
  method only needs the mcmc chain to encapsulate and the log likelhood
  function generated by \code{\link{hzar.make.clineLLfunc.old.ML}} or
  \code{\link{hzar.make.clineLLfunc.old.bayes}}.

  Use \code{\link{hzar.dataGroup.add}} and
  \code{\link{hzar.fit2DataGroup}} instead of this method as they
  operate directly on a \code{\link{hzar.fitRequest}} object.
}
\usage{
hzar.make.dataGroup(data.mcmc,
                    llFunc,
                    ML.cline = NULL,
                    doPar = FALSE,
                    data.LL = hzar.eval.clineLL(llFunc = llFunc,
                                                data = data.mcmc,
                                                doPar = doPar),
                    data.param = as.data.frame(data.mcmc),
                    obsData = hzar.extract.obsData(llFunc))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data.mcmc}{
    The mcmc chain to encapsulate.
  }
  \item{llFunc}{
    The log likelihood function of the model.
  }
  \item{ML.cline}{
    The \code{\link{hzar.cline}} of maximum likelihood.
    Automatically calculated from \code{data.mcmc} if NULL. 
  }
  \item{doPar}{
    Argument passed to \code{\link{hzar.eval.clineLL}}.
  }
  \item{data.LL}{
    The log likelihood of each row of data.mcmc. 
  }
  \item{data.param}{
    \code{data.mcmc} as a \code{data.frame}.
  }
  \item{obsData}{
    The \code{\link{hzar.obsData}} object backing the
    \code{hzar.dataGroup} created.
  }
}
% \details{
% %%  ~~ If necessary, more details than the description above ~~
% }
\value{
  Object of class \code{hzar.dataGroup}
\item{llFunc}{\code{llFunc} from above.}
\item{data.mcmc}{\code{data.mcmc} from above.}
\item{data.param}{\code{data.mcmc} as a \code{data.frame}.}
\item{data.LL}{The log likelihood of each row of \code{data.param}.}
\item{ML.cline}{See \code{\link{hzar.get.ML.cline}}.}
\item{obsData}{The \code{\link{hzar.obsData}} object backing
  \code{llFunc}. }
}
% \references{
% %% ~put references to the literature/web site here ~
% }
\author{
Graham Derryberry \email{asterion@alum.mit.edu}
}
% \note{
% %%  ~~further notes~~
% }

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
  \code{\link{hzar.eval.clineLL}}
  \code{\link{hzar.extract.obsData}}
  \code{\link{hzar.dataGroup.add}}
  \code{\link{hzar.fit2DataGroup}}
}

% % Add one or more standard keywords, see file 'KEYWORDS' in the
% % R documentation directory.
% \keyword{ ~kwd1 }
% \keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
