% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gentime.R
\name{gentime}
\alias{gentime}
\title{Generating Irregularly spaced times}
\usage{
gentime(n, lambda1 = 130, lambda2 = 6.5, p1 = 0.15, p2 = 0.85)
}
\arguments{
\item{n}{A positive integer. Length of observations times.}

\item{lambda1}{Mean (1/rate) of the first exponential distribution.}

\item{lambda2}{Mean (1/rate) of the second exponential distribution.}

\item{p1}{Weight of the first exponential distribution.}

\item{p2}{Weight of the second exponential distribution.}
}
\value{
Array with irregularly spaced observations times
}
\description{
Function to generate irregularly spaced times from a mixture of exponential distributions.
}
\examples{
st<-gentime(n=100)
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{IAR.sample}}
}
