% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotD3_break_down.R
\name{plotD3}
\alias{plotD3}
\alias{plotD3.break_down}
\title{Plot Break Down Objects in D3 with r2d3 package.}
\usage{
plotD3(x, ...)

\method{plotD3}{break_down}(x, ..., baseline = NA, max_features = 10,
  digits = 3, rounding_function = round, bar_width = 12,
  margin = 0.2, scale_height = FALSE, min_max = NA, vcolors = NA,
  chart_title = NA, time = 0)
}
\arguments{
\item{x}{an explanation created with \code{\link{break_down}}}

\item{...}{other parameters.}

\item{baseline}{if numeric then veritical line will start in baseline.}

\item{max_features}{maximal number of features to be included in the plot. Default value is 10.}

\item{digits}{number of decimal places (round) or significant digits (signif) to be used.
See the \code{rounding_function} argument.}

\item{rounding_function}{a function to be used for rounding numbers.
This should be \code{\link{signif}} which keeps a specified number of significant digits or \code{\link{round}} (which is default) to have the same precision for all components.}

\item{bar_width}{width of bars in px. By default 12px}

\item{margin}{extend x axis domain range to adjust the plot. Usually value between 0.1 and 0.3, by default it's 0.2}

\item{scale_height}{if TRUE, the height of the plot scales with window size}

\item{min_max}{a range of OX axis. By deafult `NA` therefore will be extracted from the contributions of `x`.
But can be set to some constants, usefull if these plots are used for comparisons.}

\item{vcolors}{If NA (default), DrWhy colors are used.}

\item{chart_title}{a character. Set custom title}

\item{time}{in ms. Set animation length}
}
\value{
a `r2d3` object.
}
\description{
Plots waterfall break down for objects of the `break_down` class.
}
\examples{
library("DALEX")
library("iBreakDown")

titanic <- na.omit(titanic)
set.seed(1313)
titanic_small <- titanic[sample(1:nrow(titanic), 500), c(1,2,6,9)]
model_titanic_glm <- glm(survived == "yes" ~ gender + age + fare,
                       data = titanic_small, family = "binomial")
explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic_small[,-9],
                           y = titanic_small$survived == "yes",
                           label = "glm")
bd_glm <- local_attributions(explain_titanic_glm, titanic_small[1, ])
bd_glm
plotD3(bd_glm)

library(randomForest)

m_rf <- randomForest(status ~ . , data = HR[2:2000,])
new_observation <- HR_test[1,]
new_observation

p_fun <- function(object, newdata){predict(object, newdata=newdata, type = "prob")}

bd_rf <- local_attributions(m_rf,
                           data = HR_test,
                           new_observation =  new_observation,
                           predict_function = p_fun)

bd_rf
plotD3(bd_rf)

}
\references{
Predictive Models: Visual Exploration, Explanation and Debugging \url{https://pbiecek.github.io/PM_VEE}
}
