\name{tts.autoML}
\alias{tts.autoML}

\encoding{latin1}

\title{Train time series by automatic machine learning of \code{h2o} provided by H2O.ai}

\description{
It generates  both the static and recursive time series plots of H2O.ai object generated by package \code{h2o} provided by H2O.ai.
}

\usage{
tts.autoML(y,x=NULL,train.end,arOrder=2,xregOrder=0,type,max_models = 20,
                      sort_metric="AUTO",stopping_metric = "AUTO")
}

\arguments{
  \item{y}{
The time series object of the target variable, for example, \code{timeSeries},\code{xts}, or \code{zoo}. Numerically,y must be real numbers for regression or integers for classification. Date format must be "%Y-%m-%d".
}

  \item{x}{The time series matrix of input variables, timestamp is the same as y, maybe null.
}


  \item{train.end}{The end date of training data, must be specificed. The default dates of train.start and test.end are the start and the end of input data; and the test.start is the 1-period next of train.end.

}


\item{arOrder}{The autoregressive order of the target variable, which may be sequentially specifed like arOrder=1:5; or discontinuous lags like arOrder=c(1,3,5); zero is not allowed.

}

\item{xregOrder}{The distributed lag structure of the input variables, which may be sequentially specifed like xregOrder=1:5; or discontinuous lags like xregOrder=c(0,3,5); zero is allowed since contemporaneous correlation is allowed.

}

\item{type}{The time dummies variables. We have four selection:\cr 'none'=no other variables,\cr 'trend'=inclusion of time dummy, \cr 'season'=inclusion of seasonal dummies, \cr 'both'=inclusion of both trend and season. No default.

}

\item{max_models}{Number of AutoML base models, default to 20.}

\item{sort_metric}{Specifies the metric used to sort the Leaderboard by at the end of an AutoML run. Defaults to "AUTO", where  'AUC' (area under the ROC curve) for binary classification, 'mean_per_class_error' for multinomial classification, and 'deviance' for regression. Available options include:'MSE','RMSE','MAE','RMSLE','AUCPR' (area under the Precision-Recall curve)}

\item{stopping_metric}{Specify the metric to use for early stopping. Defaults to "AUTO",where 'logloss' for classification and 'deviance' for regression. Besides, options are: 'MSE','RMSE','MAE','RMSLE','AUC','AUCPR','lift_top_group'}


}


\details{

This function calls the h2o.automl function from package \code{h2o} to execute automatic machine learning estimation. When execution finished, it computes two types of time series forecasts: static and recursive. The procedure of h2o.automl automatically generates a lot of time features.
}



\value{

  \item{output}{Output object generated by h2o.automl function of \code{h2o}.}
  \item{modelsUsed}{AutoML Leaderboard object, which is a table returns the argument of 'max_models'.}
  \item{arOrder}{The autoregressive order of the target variable used.}
  \item{dataused}{The data used by arOrder, xregOrder}
  \item{data}{The complete data structure}
  \item{TD}{Time dummies used, inherited from 'type' in tts.autoML}
  \item{train.end}{The same as the argument in tts.autoML}
}


\author{
Ho Tsung-wu <tsungwu@ntnu.edu.tw>, College of Management, National Taiwan Normal University.

}

\examples{
# Computation takes time, example below is commented.
data("macrodata")
dep<-macrodata[,"unrate",drop=FALSE]
ind<-macrodata[,-1,drop=FALSE]

# Choosing the dates of training and testing data
train.end<-"2008-12-01"

#autoML of H2O.ai

# autoML <- tts.autoML(y=dep, x=ind, train.end,arOrder=c(2,4),
# xregOrder=c(0,1,3),type="both")
# print(autoML$modelsUsed,n=22) #View the AutoML Leaderboard

#testData2 <- window(autoML$dataused,start="2009-01-01",end=end(autoML$dataused))
#P1<-iForecast(Model=autoML,Type="static",newdata=testData2)
#P2<-iForecast(Model=autoML,Type="dynamic",n.ahead=nrow(testData2))

#tail(cbind(testData2[,1],P1))
#tail(cbind(testData2[,1],P2))


}

