% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_match_class.R
\name{plot,igraph,igraph-method}
\alias{plot,igraph,igraph-method}
\alias{plot,Matrix,Matrix-method}
\title{Plotting methods for visualizing matches}
\usage{
\S4method{plot}{igraph,igraph}(x, y, match = NULL, color = TRUE, linetype = TRUE, ...)

\S4method{plot}{Matrix,Matrix}(x, y, match = NULL, col.regions = NULL, at = NULL, colorkey = NULL, ...)
}
\arguments{
\item{x}{First graph, either an igraph object or a Matrix}

\item{y}{second graph, either an igraph object or a Matrix}

\item{match}{result from a match call. Requires element
\code{corr} as a data.frame with names corr_A, corr_B.}

\item{color}{Whether to color edges according to which
graph(s) they are in.}

\item{linetype}{Whether to set edge line types according
to which graph(s) they are in.}

\item{...}{additional parameters passed to either the
igraph plot function or the Matrix image function.}

\item{col.regions}{NULL for default colors, otherwise see \link[Matrix]{image-methods}}

\item{at}{NULL for default at values for at (ensures zero is grey), otherwise see \link[Matrix]{image-methods}}

\item{colorkey}{NULL for default colorkey, otherwise see \link[Matrix]{image-methods}}
}
\value{
Both functions return values invisibly.
\code{match_plot_igraph} returns the union of the
 matched graphs as an igraph object with additional
 edge attributes \code{edge_match, color, lty}.
 \code{match_plot_matrix} returns the difference between
 the matched graphs.
}
\description{
Two functions are provided, \code{match_plot_igraph}
which makes a ball and stick plot from igraph objects
and \code{match_plot_matrix} which shows an adjacency
matrix plot.
}
\details{
Grey edges/pixels indicate common edges, blue
indicates edges only in graph A and red
represents edges only graph B. The corresponding
linetypes are solid, long dash, and short dash.

The plots can be recreated from the output with the code \cr
\code{plot(g)} \cr
for \code{g <- match_plot_igraph(...)} and  \cr
\code{col <- colorRampPalette(c("#AA4444", "#888888", "#44AA44"))} \cr
\code{image(m, col.regions = col(256))} \cr
for \code{m <- match_plot_match(...)}.

This only plots and returns the matched vertices.
}
\examples{
set.seed(123)
graphs <- sample_correlated_gnp_pair(20, .9, .3)
A <- graphs$graph1
B <- graphs$graph2
res <- gm(A, B, 1:4, method = "percolation")

plot(A, B, res)
plot(A[], B[], res)
}
