% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/EstIndex.R
\name{ChaoEntropy}
\alias{ChaoEntropy}
\title{Estimation of Shannon entropy/diversity}
\usage{
ChaoEntropy(x, datatype = "abundance", transform = FALSE, conf = 0.95,
  B = 200)
}
\arguments{
\item{x}{a vector of species abundances or incidence frequencies. If \code{datatype = "incidence"},
then the first entry of the input data must be total number of sampling units, followed by species incidence frequencies.}

\item{datatype}{data type of input data: individual-based abundance data (\code{datatype = "abundance"}) or sampling-unit-based incidence data (\code{datatype = "incidence"}).}

\item{transform}{a \code{logical} constant to compute traditional Shannon entropy index (\code{transform=FALSE}) or the transformed Shannon diversity (\code{transform=TRUE}).}

\item{conf}{a positive number \eqn{\le} 1 specifying the level of confidence interval.}

\item{B}{an integer specifying the number of bootstrap replications.}
}
\value{
A vector of observed Shannon entropy/diversity, estimate of entropy/diversity, s.e. and the associated confidence interval.
}
\description{
\code{ChaoEntropy}: estimation of Shannon entropy or transformed Shannon diversity based on the method proposed by Chao et al. (2013).
}
\examples{
data(spider)
ChaoEntropy(spider$Girdled, datatype="abundance")
}
\references{
Chao, A., Wang, Y.T. & Jost, L. (2013) Entropy and the species accumulation curve: a novel entropy estimator via discovery rates of new species. Methods in Ecology and Evolution, 4, 1091-1100.
}
\seealso{
\code{\link{ChaoSpecies}, \link{EstSimpson}}
}

