% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_var.R
\name{transformVar}
\alias{transformVar}
\title{Transform data of a numeric variable}
\usage{
transformVar(
  .data,
  var,
  transformation,
  name = sprintf("\%s.\%s", transformation, var)
)
}
\arguments{
\item{.data}{a dataframe with the variables to transform}

\item{var}{a character of the numeric variable in \code{.data} to transform}

\item{transformation}{a name of a valid mathematical function that can
be applied to numeric values, eg. "log", "exp", "sqrt".
For squaring, use "square"; for inverting, use "reciprocal"}

\item{name}{the name of the new variable}
}
\value{
the original dataframe containing a new column of the transformed
        variable with tidyverse code attached
}
\description{
Transform the values of a numeric variable by applying
a mathematical function
}
\examples{
transformed <- transformVar(iris, var = "Petal.Length",
    transformation = "log")
cat(code(transformed))
head(transformed)

}
\seealso{
\code{\link{code}}
}
\author{
Owen Jin
}
