% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_random.R
\name{filterRandom}
\alias{filterRandom}
\title{Random sampling without replacement}
\usage{
filterRandom(.data, n, sample_size)
}
\arguments{
\item{.data}{a dataframe to sample from}

\item{n}{the number of groups to generate}

\item{sample_size}{the size of each group specified in \code{n}}
}
\value{
a dataframe containing the random samples with
        tidyverse code attached
}
\description{
Take a specified number of groups of observations with fixed group size
by sampling without replacement
and returns the result along with tidyverse code used to generate it.
}
\examples{
filtered <- filterRandom(iris, n = 5, sample_size = 3)
cat(code(filtered))
head(filtered)

}
\seealso{
\code{\link{code}}
}
\author{
Owen Jin
}
