% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{plot.iNextPD}
\alias{plot.iNextPD}
\title{Plotting iNextPD object}
\usage{
\method{plot}{iNextPD}(x, type = 1, se = TRUE, show.legend = TRUE,
  show.main = TRUE, col = NULL, xlab = NULL, ylab = NULL, ...)
}
\arguments{
\item{x}{an \code{iNextPD} object computed by \code{\link{iNextPD}}.}

\item{type}{three types of plots: sample-size-based rarefaction/extrapolation curve (\code{type = 1}); 
sample completeness curve (\code{type = 2}); coverage-based rarefaction/extrapolation curve (\code{type = 3}).}

\item{se}{a logical variable to display confidence interval around the estimated sampling curve.}

\item{show.legend}{a logical variable to display legend.}

\item{show.main}{a logical variable to display title.}

\item{col}{a vector for plotting color.}

\item{xlab}{a title for the x axis.}

\item{ylab}{a title for the y axis.}

\item{...}{arguments to be passed to methods, such as graphical parameters (\code{\link{par}}).}
}
\description{
\code{plot.iNextPD}: Plotting method for objects inheriting from class "iNextPD"
}
\examples{

# single-assemblage abundance data
data(bird)
bird.phy <- ade4::newick2phylog(bird$tre)
bird.lab <- rownames(bird$abun)
out1 <- iNextPD(bird$abun$North.site, bird.lab, bird.phy, 
        q=1, datatype="abundance", endpoint=500)
plot(x=out1, type=1)
plot(x=out1, type=2)
plot(x=out1, type=3)

}

