% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_helper_functions.R
\name{split_large_zip}
\alias{split_large_zip}
\title{Split Large Zip File into Smaller Parts}
\usage{
split_large_zip(zip_file, max_size = 500, quiet = FALSE)
}
\arguments{
\item{zip_file}{The path to the large zip file.}

\item{max_size}{The maximum size (in MB) for each split zip file. Default is 500 MB.}

\item{quiet}{Logical. If TRUE, suppresses messages about the progress and completion of the zip process. Default is FALSE.}
}
\value{
This function does not return any value; it creates multiple smaller zip files.
}
\description{
This helper function takes an existing zip file, extracts its contents,
and splits it into smaller zip files without splitting subfolders.
}
\examples{
\dontrun{
# Split an existing zip file into parts of up to 500 MB
split_large_zip("large_file.zip", max_size = 500)
}
}
