% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_list_dashboard_bins.R
\name{ifcb_list_dashboard_bins}
\alias{ifcb_list_dashboard_bins}
\title{Download bin list from the IFCB Dashboard API}
\usage{
ifcb_list_dashboard_bins(base_url, quiet = FALSE)
}
\arguments{
\item{base_url}{Character. Base URL to the IFCB Dashboard
(e.g. "https://ifcb-data.whoi.edu/").}

\item{quiet}{Logical. If TRUE, suppresses progress messages. Default is FALSE.}
}
\value{
A data frame containing the bin list returned by the API.
}
\description{
Download bin list from the IFCB Dashboard API
}
\examples{
\dontrun{
  bins <- ifcb_list_dashboard_bins("https://ifcb-data.whoi.edu/")
  head(bins)
}

}
\seealso{
\code{\link[=ifcb_download_dashboard_data]{ifcb_download_dashboard_data()}} to download data from the IFCB Dashboard API.

\code{\link[=ifcb_download_dashboard_metadata]{ifcb_download_dashboard_metadata()}} to retrieve metadata from the IFCB Dashboard API.
}
