% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ispca.R
\name{ispca}
\alias{ispca}
\title{Integrative sparse principal component analysis}
\usage{
ispca(x, L, mu1, mu2, eps = 1e-04, pen1 = "homogeneity",
  pen2 = "magnitude", scale.x = TRUE, maxstep = 50, trace = FALSE,
  draw = FALSE)
}
\arguments{
\item{x}{list of data matrices, L datasets of explanatory variables.}

\item{L}{numeric, number of data sets.}

\item{mu1}{numeric, sparsity penalty parameter.}

\item{mu2}{numeric, contrasted penalty parameter.}

\item{eps}{numeric, the threshold at which the algorithm terminates.}

\item{pen1}{character, "homogeneity" or "heterogeneity" type of the sparsity structure. If not specified, the default is homogeneity.}

\item{pen2}{character, "magnitude" or "sign" based contrasted penalty. If not specified, the default is magnitude.}

\item{scale.x}{character, "TRUE" or "FALSE", whether or not to scale the variables x. The default is TRUE.}

\item{maxstep}{numeric, maximum iteration steps. The default value is 50.}

\item{trace}{character, "TRUE" or "FALSE". If TRUE, prints out its screening results of variables.}

\item{draw}{character, "TRUE" or "FALSE". If TRUE, plot the convergence path of loadings.}
}
\value{
An 'ispca' object that contains the list of the following items.
\itemize{
\item{x:}{ list of data matrices, L datasets of explanatory variables with centered columns. If scale.x is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{eigenvalue:}{ the estimated first eigenvalue.}
\item{eigenvector:}{ the estimated first eigenvector.}
\item{component:}{ the estimated first component.}
\item{variable:}{ the screening results of variables.}
\item{meanx:}{ list of numeric vectors, column mean of the original datasets x.}
\item{normx:}{ list of numeric vectors, column standard deviation of the original datasets x.}
}
}
\description{
This function provides a penalty-based integrative sparse principal component analysis method to obtain the direction of first principal component of the multiple datasets with high dimensions generated under similar protocols, which consists of two built-in penalty items for selecting the important variables for users to choose, and two contrasted penalty functions for eliminating the diffierence (magnitude or sign) between estimators within each group.
}
\examples{
# Load a list with 3 data sets
library(iSFun)
data("simData.pca")
x <- simData.pca$x
L <- length(x)

prev_pca <- preview.pca(x = x, L = L, scale.x = TRUE)
res_homo_m <- ispca(x = x, L = L, mu1 = 0.5, mu2 = 0.002, trace = TRUE, draw = TRUE)

\donttest{
res_homo_s <- ispca(x = x, L = L, mu1 = 0.5, mu2 = 0.002,
                    pen1 = "homogeneity", pen2 = "sign", scale.x = TRUE,
                    maxstep = 50, trace = FALSE, draw = FALSE)

res_hete_m <- ispca(x = x, L = L, mu1 = 0.2, mu2 = 0.05,
                    pen1 = "heterogeneity", pen2 = "magnitude", scale.x = TRUE,
                    maxstep = 50, trace = FALSE, draw = FALSE)

res_hete_s <- ispca(x = x, L = L, mu1 = 0.2, mu2 = 0.05,
                    pen1 = "heterogeneity", pen2 = "sign", scale.x = TRUE,
                    maxstep = 50, trace = FALSE, draw = FALSE)
}
}
\references{
\itemize{
\item{Fang K, Fan X, Zhang Q, et al. Integrative sparse principal component analysis[J]. Journal of Multivariate Analysis, 2018, 166: 1-16.}
}
}
\seealso{
See Also as \code{\link{preview.pca}}, \code{\link{ispls}}, \code{\link{iscca}}.
}
