% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{split_data}
\alias{split_data}
\title{Split the data into training and test datasets}
\usage{
split_data(task, X, ...)
}
\arguments{
\item{task}{The type of problem.}

\item{X}{The features of the data.}

\item{...}{Other parameters, including zero or more target vectors as
required by the problem type. Refer to the Julia documentation for
available parameters.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/IAIBase/stable/reference/#IAI.split_data}{\code{IAI.split_data}}
}
\examples{
\donttest{
X <- iris[, 1:4]
y <- iris$Species
split <- iai::split_data("classification", X, y, train_proportion = 0.75)
train_X <- split$train$X
train_y <- split$train$y
test_X <- split$test$X
test_y <- split$test$y
}
}
