% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibdsim.R
\name{ibdsim}
\alias{ibdsim}
\title{IBD simulation}
\usage{
ibdsim(
  x,
  N = 1,
  ids = labels(x),
  map = "decode",
  chrom = NULL,
  model = c("chi", "haldane"),
  skipRecomb = NULL,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{A \code{\link[pedtools:ped]{pedtools::ped()}} object.}

\item{N}{A positive integer indicating the number of simulations.}

\item{ids}{A subset of pedigree members whose IBD sharing should be analysed.
If NULL, the simulations are returned unprocessed.}

\item{map}{The genetic map to be used in the simulations: One of the
character strings "decode", "uniform.sex.spec", "uniform.sex.aver". (See
Details.)}

\item{chrom}{A numeric vector indicating chromosome numbers, or either of the
words "AUTOSOMAL" or "X". The default is 1:22, i.e., the human autosomes.}

\item{model}{Either "chi" (default) or "haldane", indicating the statistical
model for recombination. (See details.)}

\item{skipRecomb}{A vector of ID labels indicating individuals whose meioses
should be simulated without recombination. (Each child will then receive a
random strand of each chromosome.) The default action is to skip
recombination in founders who are uninformative for IBD sharing in the
\code{ids} individuals.}

\item{seed}{An integer to be passed on to \code{\link[=set.seed]{set.seed()}}).}

\item{verbose}{A logical.}
}
\value{
A list of \code{N} objects of class \code{genomeSim}.

A \code{genomeSim} object is essentially a numerical matrix describing the
allele flow through the pedigree in a single simulated. Each row
corresponds to a chromosomal segment. The first 4 columns describe the
segment (chromosome, start, end, length), and are followed by two columns
(paternal allele, maternal allele) for each of the \code{ids} individuals.

If \code{ids} has length 1, a column named "Aut" is added, whose entries are 1
for autozygous segments and 0 otherwise.

If \code{ids} has length 2, two columns are added:
\itemize{
\item \code{IBD} : The IBD status of each segment (= number of alleles shared
identical by descent). For a given segment, the IBD status is either 0, 1,
2 or NA. If either individual is inbred, they may be autozygous in a
segment, in which case the IBD status is reported as NA. With inbred
individuals the \code{Sigma} column (see below) is more informative than the
\code{IBD} column.
\item \code{Sigma} : The condensed identity ("Jacquard") state of each segment,
given as an integer in the range 1-9. The numbers correspond to the
standard ordering of the condensed states. In particular, for non-inbred
individuals the states 9, 8, 7 correspond to IBD status 0, 1, 2
respectively.
}
}
\description{
This is the main function of the package, simulating the recombination
process in each meioses of a pedigree. The output summarises the IBD segments
between all or a subset of individuals.
}
\details{
Each simulation starts by unique alleles (labelled 1, 2, ...) being
distributed to the pedigree founders. In each meiosis, homologue chromosomes
are made to recombine according to the value of \code{model}:
\itemize{
\item \code{model = "haldane"}: In this model, crossover events are modelled as a
Poisson process along each chromosome.
\item \code{model = "chi"} (default): This uses a renewal process along the
four-strand bundle, with waiting times following a chi square distribution.
}

Recombination rates along each chromosome are determined by the \code{map}
parameter, which can take on the following values:
\itemize{
\item \code{map = "decode"} (default): The fine-scale Decode recombination map of the
human genome (Kong et al., 2010)
\item \code{map = "uniform.sex.spec"}: This uses the genetic chromosome \emph{lengths} from
the Decode map, but with constant recombination rate along each chromosome
(i.e., no hot/cold spots).
\item \code{map = "uniform.sex.aver"}: As the previous map, but with sex-averaged
genetic chromosome lengths.
\item A user-defined map, typically made with \link{uniformMap}.
}
}
\examples{

hs = halfSibPed()
ibdsim(hs, N = 2, map = uniformMap(M = 1), ids = 4:5)

# Full sib mating: all 9 states are possible
x = fullSibMating(1)
sim = ibdsim(x, N = 1, ids = 5:6, map = uniformMap(M = 10), seed = 1)
s = sim[[1]]
stopifnot(setequal(s[, 'Sigma'], 1:9))

}
\references{
Kong et al. \emph{Fine-scale recombination rate differences between
sexes, populations and individuals.} Nature 467, 1099–1103 (2010).
}
