% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/karyogram.R
\name{karyogram2}
\alias{karyogram2}
\title{Karyogram plots}
\usage{
karyogram2(sim, ids = NULL, verbose = TRUE, ...)
}
\arguments{
\item{sim}{A \code{genomeSim} object.}

\item{ids}{A vector of one or two ID labels.}

\item{verbose}{A logical.}

\item{...}{Further arguments passed on to \code{karyoHaploid()}.}
}
\value{
A plot object returned invisibly.
}
\description{
Functions for visualising IBD segments in karyograms. The \code{karyogram1()} and
\code{karyogram2()} functions produces karyograms illustrating the output of
\code{\link[=ibdsim]{ibdsim()}} for one or two specified individuals. The actual plotting is done
by functions \code{karyoHaploid()} and \code{karyoDiploid()}.
}
\examples{
\donttest{
x = quadHalfFirstCousins()
s = ibdsim(x, seed = 1729)
# karyogram2(s, ids = leaves(x), title = "QHFC")
}

}
