% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileSimIBD.R
\name{profileSimIBD}
\alias{profileSimIBD}
\title{Simulate markers conditional on a given IBD pattern}
\usage{
profileSimIBD(
  x,
  ibdpattern,
  ids = NULL,
  markers = NULL,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{A \code{ped} object.}

\item{ibdpattern}{A \code{genomeSim()} object, typically created by \code{\link[=ibdsim]{ibdsim()}}.
(See Examples).}

\item{ids}{A vector of ID labels. If NULL, extracted from \code{ibdpattern}.}

\item{markers}{A vector with names or indices of markers attached to \code{x}.}

\item{seed}{An integer seed for the random number generator.}

\item{verbose}{A logical, by default TRUE.}
}
\value{
A copy of \code{x} where marker genotypes have been simulated conditional
on \code{ibdpattern}.
}
\description{
This function simulates genotypes for a set of markers conditional on a
specific underlying IBD pattern (typically produced with \code{\link[=ibdsim]{ibdsim()}}).
}
\details{
It should be noted that the only \emph{random} part of this function is the
sampling of founder alleles for each marker. Given those, all other genotypes
in the pedigree are determined by the underlying IBD pattern.
}
\examples{

# Brother-sister pedigree
ped = nuclearPed(2, sex = 1:2)

# Alleles
als = letters[1:10]


### Autosomal simulation

x = ped |> 
  addMarker(alleles = als, chrom = 1, posMb = 20) |> 
  addMarker(alleles = als, chrom = 1, posMb = 50) |> 
  addMarker(alleles = als, chrom = 1, posMb = 70)
  
# Simulate the underlying IBD pattern in the pedigree
sim = ibdsim(x, map = uniformMap(M = 1, chrom = 1), seed = 123)

# Simulate genotypes for the sibs conditional on the given IBD pattern
profileSimIBD(x, sim, ids = 3:4, seed = 123)

# With a different seed
profileSimIBD(x, sim, ids = 3:4, seed = 124)


### X chromosomal simulation

y = ped |> 
  addMarker(alleles = als, chrom = "X", posMb = 1) |> 
  addMarker(alleles = als, chrom = "X", posMb = 50) |> 
  addMarker(alleles = als, chrom = "X", posMb = 100)

simy = ibdsim(y, map = loadMap("decode19", chrom = 23), seed = 11)

profileSimIBD(y, simy, seed = 12)

}
\seealso{
\code{\link[=ibdsim]{ibdsim()}}, \code{forrel::profileSim()}.
}
