% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rccat.R
\name{rccat}
\alias{rccat}
\title{Generate Correlated Clustered Categorical Data}
\usage{
rccat(
  rho,
  prop,
  prvar = 0,
  noc,
  csize,
  csvar = 0,
  allevtcl = TRUE,
  drawn = 10,
  nowarnings = FALSE
)
}
\arguments{
\item{rho}{Numeric value between 0 and 1 of the desired ICC value.}

\item{prop}{Numeric vector of each response category's probability, each taking value between 0 and 1.}

\item{prvar}{Numeric value or vector of values between 0 and 1 denoting percent variation in each assumed event rate. Default is 0.}

\item{noc}{Numeric value of number of clusters to be generated.}

\item{csize}{Numeric value of desired cluster size.}

\item{csvar}{Numeric value between 0 and 1 denoting percent variation in cluster sizes. Default is 0.}

\item{allevtcl}{Logical value specifying whether all clusters must have all categories. Default is True.}

\item{drawn}{Maximum number of attempts to apply variation to event probabilities.}

\item{nowarnings}{Flag to turn off warnings. Default is False.}
}
\value{
Dataframe with two columns, a column identifier 'cid' and categorical response 'y', and one row for each observation within each cluster
}
\description{
Generate Correlated Clustered Categorical Data
}
\examples{
rccat(rho=0.2, prop=c(0.2, 0.3, 0.5), prvar=0, noc=5, csize=20, csvar=0.2)
rccat(rho=0.1, prop=c(0.2, 0.4, 0.3, 0.1), prvar=0.10, noc=30, csize=40, csvar=0)
}
