% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges.R
\name{icd9ExpandMinor}
\alias{icd9ExpandMinor}
\title{expand decimal part of ICD-9 code to cover all possible sub-codes}
\usage{
icd9ExpandMinor(minor, isE = FALSE)
}
\arguments{
\item{minor}{character vector of 'minor' part of ICD-9 codes, i.e. that part
which falls after the decimal point, in decimal notation. (In 5 digit
notation, the 'major' part is be xyz, even when x and y are zero, thus the
last two characters represent the 'minor' part, in this case.)}

\item{isE}{single logical, which if TRUE, treats the minor as part of an E
code (which is one character), as opposed to a V or numeric-only code,
which is two character. Default is \code{FALSE}.}
}
\value{
NA for invalid minor, otherwise a vector of all possible (perhaps
  non-existent) sub-divisions.
}
\description{
Accepts a single number or character input starting point for
  generation of all possible decimal parts of ICD9 code. e.g. giving an empty
  input will fill out 111 combinations, e..g .1 .11 .12 .... .2 ....
}
\examples{
  # return all possible decimal parts of ICD9 codes (111 in total)
  length(icd9:::icd9ExpandMinor("", isE = FALSE))
  icd9:::icd9ExpandMinor("1") # "1"  "10" "11" "12" "13" "14" "15" "16" "17" "18" "19"
}
\seealso{
Other ICD-9 ranges: \code{\link{icd9Children}},
  \code{\link{icd9Condense}}, \code{\link{icd9ExpandRange}}
}
\keyword{internal}
\keyword{manip}

