% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.dls.R
\name{read.dls}
\alias{read.dls}
\title{Read DLS3.2 Results from File}
\usage{
read.dls(file)
}
\arguments{
\item{file}{a filename.}
}
\value{
A list containing \code{advice} and other elements showing intermediate steps
in the calculations.
}
\description{
Read results from the \code{DLS3.2} advisory method from a file into a list.
}
\examples{
\dontrun{
survey <- data.frame(year=2001:2010, randu[1:10,])
dls <- icesAdvice::DLS3.2(1000, survey$y)

write.dls(dls, "dls.txt")
read.dls("dls.txt")

file.remove("dls.txt")
}

}
\seealso{
\code{\link{write.dls}} writes \code{DLS3.2} results to a file.

\code{\link{DLS3.2}} can be used to calculate catch advice for data-limited
stocks (DLS).

\code{\link{icesAdvice-package}} gives an overview of the package.
}
