% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHHdata.R
\name{getHHdata}
\alias{getHHdata}
\title{Haul meta data}
\usage{
getHHdata(survey, year, quarter)
}
\arguments{
\item{survey}{the survey accronym e.g. NS-IBTS, BITS.}

\item{year}{the numeric year of the survey, e.g. 2010.}

\item{quarter}{the quarter of the year the survey took place, i.e. 1, 2, 3 or 4.}
}
\value{
A data.frame.
}
\description{
Returns detailed haul-based meta-data of the survey such as haul position, sampling method etc.
}
\examples{
# read meta data
hhdata <- getHHdata(survey = "NS-IBTS", year = 2016, quarter = 1)
str(hhdata)

# error checking examples:
hhdata <- getHHdata(survey = "NS_IBTS", year = 2016, quarter = 1)
hhdata <- getHHdata(survey = "NS-IBTS", year = 2018, quarter = 1)
hhdata <- getHHdata(survey = "NS-IBTS", year = 2016, quarter = 6)

# multiple year example
hhdata <- do.call(rbind,
                  lapply(2015:2016,
                         function(year)
                           getHHdata(survey = "NS-IBTS", year = year, quarter = 1)
                         )
                 )
str(hhdata)


}
\author{
Colin Millar.
}
\seealso{
\code{\link{getSurveyList}} returns the acronyms for available surveys.

\code{\link{getSurveyYearList}} returns the years available for a given survey.

\code{\link{getSurveyYearQuarterList}} returns the quarters available for a given survey and year.

\code{\link{icesDatras-package}} gives an overview of the package.
}

