% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceDir.R
\name{sourceDir}
\alias{sourceDir}
\title{Source Directory}
\usage{
sourceDir(dir, pattern = "\\\\.[r|R]$", all.files = FALSE,
  recursive = FALSE, quiet = TRUE, ...)
}
\arguments{
\item{dir}{a directory containing R source files.}

\item{pattern}{passed to \code{\link{dir}} when selecting files.}

\item{all.files}{passed to \code{dir} when selecting files.}

\item{recursive}{passed to \code{dir} when selecting files.}

\item{quiet}{whether to suppress showing names of sourced files.}

\item{\dots}{passed to \code{source} when sourcing files.}
}
\value{
Names of sourced files.
}
\description{
Read all \code{*.R} files from a directory containing R functions.
}
\details{
The \code{dir} argument can also be a vector of filenames, instead of a
directory  name. This can be useful to specify certain files while avoiding
others.
}
\note{
This function is convenient in TAF analyses when many R utility functions are
stored in a directory, see example below.
}
\examples{
\dontrun{
sourceDir("bootstrap/software/utilities")
}

}
\seealso{
\code{\link{source}} is the base function to read R code from a file.

\code{\link{icesTAF-package}} gives an overview of the package.
}
