% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{clean}
\alias{clean}
\title{Clean TAF Directories}
\usage{
clean(dirs = c("data", "model", "output", "report"), force = FALSE)
}
\arguments{
\item{dirs}{directories to delete.}

\item{force}{passed to \code{software} and \code{clean.library} if any of the
\code{dirs} is \code{"bootstrap"}.}
}
\description{
Remove working TAF directories (\verb{data}, \verb{model}, \verb{output},
\verb{report}), \verb{bootstrap}, or other directories.
}
\note{
The purpose of removing the directories is to make sure that subsequent TAF
scripts start by creating new empty directories.

If any of the \code{dirs} is \code{"bootstrap"} it is treated specially.
Instead of completely removing the \verb{bootstrap} directory, only the
subdirectories \verb{data} is removed, while \code{clean.software} and
\code{clean.library} are used to clean the \verb{bootstrap/software} and
\verb{bootstrap/library} subdirectories. This protects the subdirectory
\verb{bootstrap/initial} and \verb{*.bib} metadata files from being
accidentally deleted.
}
\examples{
\dontrun{
clean()
}

}
\seealso{
\code{\link{clean.software}} selectively removes software from
\verb{bootstrap/software}.

\code{\link{clean.library}} selectively removes packages from
\verb{bootstrap/library}.

\code{\link{mkdir}} and \code{\link{rmdir}} create and remove empty
directories.

\code{\link{icesTAF-package}} gives an overview of the package.
}
