% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat.R
\name{strat}
\alias{strat}
\title{Create Ichimoku Strategies}
\usage{
strat(
  x,
  c1 = c("close", "chikou", "open", "high", "low", "tenkan", "kijun", "senkouA",
    "senkouB", "cloudTop", "cloudBase"),
  c2 = c("tenkan", "kijun", "senkouA", "senkouB", "cloudTop", "cloudBase", "chikou",
    "close", "open", "high", "low"),
  dir = c("long", "short")
)
}
\arguments{
\item{x}{an ichimoku object.}

\item{c1}{column name specified as a string, with a default of 'close'.}

\item{c2}{column name specified as a string, with a default of 'tenkan'.}

\item{dir}{trade direction either 'long' or 'short' with a default of 'long'.}
}
\value{
An ichimoku object augmented with the strategy.
}
\description{
Create custom ichimoku cloud strategies using the rule condition 'long (or
    short) while c1 > c2'.
}
\details{
The following assumption applies to all strategies: confirmation of
    whether a condition is satisfied is received at the 'close' of a particular
    period, and a transaction is initiated at the next 'open'. All transactions
    happen at the 'open'.

    The original ichimoku object 'x' is augmented with the following
    additional columns used to calculate the strategy:

    'cond', a boolean vector if the rule condition is met, 'posn', a boolean
    vector indicating if a position is held, and 'txn', a vector representing
    the transactions to implement the position.

    logret' is a column of log returns, 'slogret' is a column of log returns
    for the strategy.

    ret' is a column of discrete returns, and 'sret' is a column of discrete
    returns for the strategy.

    The stategy summary is saved as an object attribute and may be accessed
    via the summary() function.

    The periods in which the strategy results in a position is shaded by
    default on the ichimoku cloud chart. To turn off this behaviour, pass the
    'strat = FALSE' argument to plot().
}
\section{Further Details}{

    Please refer to the strategies vignette by running:
    \code{vignette("strategies", package = "ichimoku")}
}

\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")
strat <- strat(cloud, c1 = "close", c2 = "tenkan")
summary(strat)
plot(strat)

}
