% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ego_reshape.R
\name{ego_reshape}
\alias{ego_reshape}
\title{Reshaping Egocentric Data (\code{ego_reshape})}
\usage{
ego_reshape(
  data,
  ego_id,
  ego_vars,
  alters,
  alter_vars,
  alter_alter,
  aa_vars = NULL,
  directed = NULL,
  loops = NULL,
  missing_code = 99999,
  output_name = "ego_long"
)
}
\arguments{
\item{data}{A data frame containing egocentric network data in a wide format.}

\item{ego_id}{A character value indicating the name of the column in \code{data} containing ego identifiers, or a numeric value indicating the position of the column containing ego identifiers.}

\item{ego_vars}{A character vector indicating the names of the columns in \code{data} containing ego-level measures, or a numeric vector indicating the positions of the columns containing ego-level measures.}

\item{alters}{A character vector indicating the names of the columns in \code{data} containing ego-alter ties, or a numeric vector indicating the positions of the columns containing ego-alter ties.}

\item{alter_vars}{A character vector indicating the names of the columns in \code{data} containing alter-level measures, or a numeric vector indicating the positions of the columns containing alter-level measures. Variables are assumed to be ordered such that each consecutive set of columns represent a single alter-level variable, and that columns within this set are ordered such that the first column represents the value associated with the alter represented by the first column specified in \code{alters}, the second column in the set is associated with the alter represented by the second column in \code{alters}, and so on. If a certain variable was collected for only the first \code{n} alters in a survey instrument, we recommend creating placeholder columns in which all values are coded \code{NA}.}

\item{alter_alter}{A character vector indicating the names of the columns in \code{data} that indicate the presence of alter-alter ties, or a numeric vector indicating the positions of the columns indicating alter-alter ties. These columns should be ordered such that their values appear as they would were one to move left-to-right, top-to-bottom in an adjacency matrix. For example, the value of column 1 should usually indicate whether a tie exists between alter 1 and alter 2, the value of column 2 should indicate the presence of a tie between alter 1 and alter 3, the value of column 3 should indicate the presence of a tie between alter 1 and alter 4, and so on. The number of columns needed to represent the full set of possible ties between alters may vary depending on a) whether ties in the network are directed or undirected, and b) whether it is possible for alters to be tied to themselves. If users do not specify these conditions using the \code{directed} and \code{loops} arguments, respectively, This function uses the number of columns specified in \code{alters} to detect the presenece of directed ties and self-loops in the network.}

\item{aa_vars}{A character vector indicating the names of the columns in \code{data} representing edge-level characteristics of alter-alter ties. Columns should be ordered in a similar fashion as with \code{alter_vars} where consecutive sets of \code{n} columns represent a single variable and columns within these sets are ordered in the same way as their corresponding edge indicator columns are ordered in \code{alter_alter}.}

\item{directed}{A logical value indicating whether alter-alter ties are directed or undirected.}

\item{loops}{A logical value indicating whether alter-alter ties contain self-loops (alters can be tied to themselves).}

\item{missing_code}{A numeric value indicating "missing" values in the alter-alter edgelist.}

\item{output_name}{A character value indicating the name or prefix that should be given to output objects.}
}
\value{
A list containing three data frames: an ego list, an ego-alter edgelist, and an alter-alter edgelist. These dataframes are optimized for use with \code{\link{ego_netwrite}}.
}
\description{
The \code{ego_reshape} function reshapes egocentric network data stored in a single wide dataset into three dataframes optimized for use with \code{\link{ego_netwrite}}.
}
