% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_imputation.R
\name{plot.IDEMFIT}
\alias{plot.IDEMFIT}
\title{Plot model fitting results}
\usage{
\method{plot}{IDEMFIT}(x, trt = NULL, mfrow = NULL, ...)
}
\arguments{
\item{x}{A class \code{IDEMFIT} object generated by \code{\link{imFitModel}}}

\item{trt}{Treatment arm selected for the diagnostic plots. If \code{NULL},
all treatment arms are included}

\item{mfrow}{Plot option}

\item{...}{Additional arguments}
}
\description{
Plot method of the class \code{IDEMFIT} to generate model fitting diagnosis
plots
}
\examples{
im.abc <- imData(abc, trt="TRT", surv="SURV", outcome=c("Y1","Y2"),
                 y0=NULL, endfml="Y2",
                 trt.label = c("UC+SBT", "SAT+SBT"),
                 cov=c("AGE"), duration=365, bounds=c(0,100));
im.fit <- imFitModel(im.abc);
plot(im.fit, mfrow=c(2,4));

}
\seealso{
\code{\link{imFitModel}}
}

