% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nni.r
\name{nni}
\alias{nni}
\title{Intrinsic Dimensionality Estimation from Near-Neighbor Information.}
\usage{
nni(x, k1 = 2, k2 = 30, DM = FALSE, eps = 0.01, p = NULL)
}
\arguments{
\item{x}{data matrix or distance matrix given by as.matrix(dist(x)).}

\item{k1}{first k-NN parameter.}

\item{k2}{second k-NN parameter.}

\item{DM}{whether \code{'x'} is distance matrix or not. logical.}

\item{eps}{accuracy parameter.}

\item{p}{ambient dimension used for automatically define \code{'k1'} and \code{'k2'}.}
}
\value{
Estimated global intrinsic dimension.
}
\description{
\code{nni} estimates intrinsic dimension of given dataset based on the nearest-neighbor
information.
}
\details{
First order expansion of the probability mass function is considered, then 
the distribution of the nearest-neighbor points from the inspection point is 
modeled by the Poisson distribution. The average of the nearest-distance is 
expressed by intrinsic dimension to be estimated.
}
\examples{
x <- gendata(DataName='SwissRoll',n=300)
estnni <- nni(x=x)
print(estnni)
}
\references{
B. Kegl. Intrinsic dimension estimation using packing numbers.
 Advances in Neural Information Processing Systems 15, 2002.

K. W. Pettis et al. An intrinsic dimensionality estimator from near
neighbor information. IEEE transactions on pattern recognition and machine intelligence, 1979.
}
\author{
Hideitsu Hino \email{hideitsu.hino@gmail.com}
}
