% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gather_strat_variable.R
\name{gather_strat_variable}
\alias{gather_strat_variable}
\title{A Function to Gather a Stratified Variable into a Tidy Format}
\usage{
gather_strat_variable(
  df,
  id_col,
  compartment,
  hold_out_var = NULL,
  strat,
  groups = NULL
)
}
\arguments{
\item{df}{A data frame with variables stratified using numeric labels.}

\item{id_col}{A character string containing the name of the new id column.}

\item{compartment}{The compartment to reduce the dimension of.}

\item{hold_out_var}{A character vector specifying the variables to keep unchanged. Defaults to NULL}

\item{strat}{An integer specifying the number of stratifications to reduce.}

\item{groups}{A character vector with length equal to the level of stratification.
Used to name the stratified levels.}
}
\value{
A dataframe of stratified model output with a single Tidy variable.
}
\description{
A Function to Gather a Stratified Variable into a Tidy Format
}
\examples{

df <- data.frame(time = 0, A1 = 1, A2 = 2, A3 = 3)
gather_strat_variable(df, id_col = "Age", compartment = "A",
                      strat = 3, groups = c("Children", "Young adults", "Adults"))
}
