% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentence.R
\name{sentence}
\alias{sentence}
\title{Sentence style identifiers}
\usage{
sentence(n = 1, style = "snake", past = FALSE)
}
\arguments{
\item{n}{number of ids to return.  If \code{NULL}, it instead
returns the generating function}

\item{style}{Style to join words with.  Can be one of "Pascal",
"camel", "snake", "kebab", "dot", "title", "sentence", "lower",
"upper", and "constant".}

\item{past}{Use the past tense for verbs (e.g., slurped or jogged
rather than slurping or jogging)}
}
\description{
Create a sentence style identifier.  This uses the approach
described by Asana on their blog
\url{https://blog.asana.com/2011/09/6-sad-squid-snuggle-softly/}.
This approach encodes 32 bits of information (so 2^32 ~= 4 billion
possibilities) and in theory can be remapped to an integer if you
really wanted to.
}
\examples{
# Generate an identifier
sentence()

# Generate a bunch
sentence(10)

# As with adjective_animal, use "style" to control punctuation
sentence(style = "Camel")
sentence(style = "dot")
sentence(style = "Title")

# Change the tense of the verb:
set.seed(1)
sentence()
set.seed(1)
sentence(past = TRUE)

# Pass n = NULL to bind arguments to a function
id <- sentence(NULL, past = TRUE, style = "dot")
id()
id(10)
}
\author{
Rich FitzJohn
}

