% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shm.R
\encoding{UTF-8}
\name{sgm}
\alias{sgm}
\title{Geometric mean}
\usage{
sgm(x, na.rm = FALSE)
}
\arguments{
\item{x}{numeric vector that contains the sample data points (any
negative values will be ignored).}

\item{na.rm}{logical vector that determines whether the missing
values should be removed or not.}
}
\value{
sample geometric mean as a numeric vector. The default choice is
  that any NA values will be kept (\code{na.rm = FALSE}). This can be
  changed by specifying \code{na.rm = TRUE}, such as \code{sgm(x, na.rm = TRUE)}.
}
\description{
This function computes the sample geometric mean.
}
\details{
Geometric mean is expressed as

\deqn{\bar{x}_g = \left(x_{1}x_{2} \cdots x_{n}\right)^{\frac{1}{n}}}

\describe{
\item{\emph{\eqn{\bar{x}_g}}}{the sample geometric mean}
\item{\emph{x}}{the values in a sample}
\item{\emph{n}}{the number of positive values}
}

"The geometric mean is used in averaging values that represent a rate of
  change. It is the positive nth root of the product of the n values."
}
\examples{
library(iemisc)
# Example 1.13 from Kottegoda (page 13)
city_pop <- c(230000, 310000)
sgm(city_pop)

# Compare the geometric mean to the arithmetic mean
mean(city_pop)

}
\references{
Nathabandu T. Kottegoda and Renzo Rosso, \emph{Statistics, Probability, and Reliability for Civil and Environmental Engineers}, New York City, New York: The McGraw-Hill Companies, Inc., 1997, page 13.
}
\seealso{
\code{\link[base]{mean}} for arithmetic mean

\code{\link{shm}} for harmonic mean, \code{\link{cv}} for coefficient of
 variation (CV), \code{\link{relerror}} for relative error, \code{\link{approxerror}} for
 approximate error, \code{\link{rms}} for root-mean-square (RMS), and \code{\link{ranges}}
 for sample range.
}

