#' iemisc: Irucka Embry's miscellaneous functions
#'
#' iemisc provides many useful functions. There are statistical analysis [RMS,
#' coefficient of variation (CV), approximate and relative error, range,
#' harmonic mean, geometric mean], engineering economics (benefit-cost,
#' future value, present value, annual value, gradients, interest, periods,
#' etc.), geometry (sphere volume and right triangle), civil & environmental/
#' water resources engineering (Air Stripper, Concrete Mix Design for Normal Strength &
#' Structural Lightweight Concrete, Manning's
#' n, Gauckler-Manning-Strickler equation for geometric cross-sections), a
#' version of linear interpolation for use with NAs, & GNU Octave/MATLAB
#' compatible size, numel, and length_octave functions.
#'
#' @docType package
#' @name iemisc
#' @import data.table stats iemiscdata import zoo gsubfn fpCompare units CHNOSZ listless stringi rgdal IAPWS95 sp
#' @importFrom pracma isempty nthroot interp1 interp2 ones
#' @importFrom testit assert
NULL