% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volsphere.R
\encoding{UTF-8}
\name{volsphere}
\alias{volsphere}
\title{Sphere volume}
\usage{
volsphere(r)
}
\arguments{
\item{r}{numeric vector, matrix, data.frame, or data.table
that contains the radius of a sphere.}
}
\value{
volume of a sphere (as L^3 units) as an R object: a numeric \code{\link{vector}}
  or a named numeric vector if using a named object (\code{\link{matrix}}, \code{\link{data.frame}},
  or \code{\link{data.table}}).
}
\description{
This function computes the volume of a sphere using a given radius.
}
\details{
The radius of a sphere is "the integral of the surface area of a sphere."

Volume of a sphere is expressed as

\deqn{V = \frac{4}{3}\pi r^3}

\describe{
\item{\emph{V}}{the volume of a sphere}
\item{\emph{r}}{the radius of a sphere}
}
}
\examples{
library(iemisc)
volsphere(3) # in

volsphere(4.5) # in


x <- c(3, 4, 0.2, 12, 34, 7.5) # cm
volsphere(x)


# using a matrix of the numeric vector x
mat1 <- matrix(data = x, nrow = length(x), ncol = 1, byrow = FALSE,
       dimnames = list(c(rep("", length(x))), "Radius"))
volsphere(mat1)


# using a data.frame of the numeric vector x
df1 <- data.frame(x)
volsphere(df1)


# using a data.table of the numeric vector x
df2 <- data.table(x)
volsphere(df2)




}
\references{
Wikimedia Foundation, Inc. Wikipedia, 30 December 2015, “Volume”, \url{https://en.wikipedia.org/wiki/Volume}.
}
