% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgivenFcont.R
\encoding{UTF-8}
\name{PgivenAcont}
\alias{PgivenAcont}
\title{Present value given Annual value [continuous] (Engineering Economics)}
\usage{
PgivenAcont(A, n, r)
}
\arguments{
\item{A}{numeric vector that contains the annual value(s)}

\item{n}{numeric vector that contains the period value(s)}

\item{r}{numeric vector that contains the continuously compounded nominal
annual interest rate(s) as a percent}
}
\value{
PgivenAcont numeric vector that contains the present value(s)
   rounded to 2 decimal places
}
\description{
Compute P given A with interest compounded continuously
}
\details{
P is expressed as

	\deqn{P = A\left[\frac{e^{rn} - 1}{e^{rn}\left(e^{r} - 1\right)}\right]}

\describe{
\item{\emph{P}}{the "present equivalent"}
\item{\emph{A}}{the "annual equivalent amount (occurs at the end of
    each year)"}
\item{\emph{r}}{the "nominal annual interest rate, compounded
    continuously"}
\item{\emph{n}}{the "number of periods (years)"}
}
}
\examples{
library("iemisc")
  PgivenAcont(2000, 3, 12) # the interest rate is 12\%




}
\references{
William G. Sullivan, Elin M. Wicks, and C. Patrick Koelling, \emph{Engineering Economy}, Fourteenth Edition, Upper Saddle River, New Jersey: Pearson/Prentice Hall, 2009, page 169.
}
