% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_solver.R
\encoding{UTF-8}
\name{prop_solver}
\alias{prop_solver}
\title{Proportion Solver}
\source{
\enumerate{
   \item Basic Mathematics. "Solving Proportions", \url{https://www.basic-mathematics.com/solving-proportions.html}
   \item Dr. Ariyana Love. "SMasks And Covid Tests Contain Nanotech Vaccines Without Informed Consent", April 7, 2021, \url{https://ambassadorlove.blog/2021/04/07/masks-and-covid-tests-contain-nanotech-vaccines-without-informed-consent/}
   \item "Electronic Support for Public Health--Vaccine Adverse Event Reporting System (ESP:VAERS) Grant Final Report"/Grant ID: R18 HS 017045 [Inclusive dates: 12/01/07 - 09/30/10]. Principal Investigator: Lazarus, Ross, MBBS, MPH, MMed, GDCompSci., page 6, \url{https://web.archive.org/web/20211230233658/https://www.nvic.org/CMSTemplates/NVIC/Pdf/FDA/ahrq-vaers-report-2011.pdf}. Retrieved thanks to the Internet Archive: Wayback Machine
}
}
\usage{
prop_solver(
  n1 = NULL,
  d1 = NULL,
  n2 = NULL,
  d2 = NULL,
  output = c("single", "all")
)
}
\arguments{
\item{n1}{numeric vector that contains the numerator 1}

\item{d1}{numeric vector that contains the denominator 1}

\item{n2}{numeric vector that contains the numerator 2}

\item{d2}{numeric vector that contains the denominator 2}

\item{output}{character vector that contains the output type, (all or
single)}
}
\value{
the missing proportion value as either a single numeric value or all
    values as characters
}
\description{
Solve the proportion for the missing numeric value in either of the
numerators or denominators
}
\examples{

# Example 1 from the Example # 1 from Reference 1

library("iemisc")

# 5 / x = 10 / 16

prop_solver(n1 = 5, n2 = 10, d2 = 16, output = "single")




# Example 2

library("iemisc")

t1 <- "34 3 1/2"
t2 <- 5
t3 <- 5 / 2

t11 <- construction_decimal(t1, result = "traditional", output = "vector")

prop_solver(n1 = t11, n2 = 5, d1 = 5 / 2, output = "all")




# Example 3

library("iemisc")

# Refer to Reference 2 and Reference 3

# What is the numerator (n1) for the situation where VAERS reports 4,576 dead
# people; however, the number of dead people is closer to 453,024 people?

d1 <- 100 / 100 # 100\%
n2 <- 4576 # number of deceased people
d2 <- 453024 # number of deceased people

prop_solver(d1 = d1, n2 = n2, d2 = d2, output = "single")


# What is the more accurate number of dead people (d2) where VAERS reports 4,576
# dead people and we recognize that less than 1\% of adverse reactions are reported
# to VAERS?

n1 <- 0.99999999999999999999999999999999999999999999999 / 100 # less than 1\%
n11 <- 0.98 / 100 # less than 1\%
d1 <- 100 / 100 # number of deceased people
n2 <- 4576 # number of deceased people

prop_solver(n1 = n1, d1 = d1, n2 = n2, output = "all")

prop_solver(n1 = n1, d1 = d1, n2 = n2, output = "single")


prop_solver(n1 = n11, d1 = d1, n2 = n2, output = "all")

prop_solver(n1 = n11, d1 = d1, n2 = n2, output = "single")








}
\author{
Irucka Embry
}
