% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\encoding{UTF-8}
\name{length_octave}
\alias{length_octave}
\title{Length of R objects (GNU Octave/MATLAB compatible)}
\usage{
length_octave(x)
}
\arguments{
\item{x}{An R object (array, matrix, vector)}
}
\value{
Return the length of the object x as an integer. "The length is 0
  for empty objects, 1 for scalars (in R, a \code{vector} of \code{length} 1), and
  the number of elements (in R, the \code{length}) for vectors. For matrix objects,
  the length is the number of rows or columns, whichever is greater (this
  odd definition is used for compatibility with MATLAB)." Source: Eaton.
}
\description{
Obtain the length of R objects [arrays, matrices, and vectors (including
lists)] in a manner compatible with GNU Octave/MATLAB. Some documentation
from \code{\link[base]{length}}.
}
\examples{

library(iemisc)

import::from(matlab, ones)

# Example from pracma isempty

object1 <- matrix(0, 1, 0)

length_octave(object1)



}
\references{
\enumerate{
   \item Samit Basu (2002-2006). FreeMat v4.0, \url{https://freemat.sourceforge.net/help/inspection_length.html}.
   \item John W. Eaton, David Bateman, Søren Hauberg, and Rik Wehbring (November 2022). \emph{GNU Octave: A high-level interactive language for numerical computations: Edition 7 for Octave version 7.3.0}. \url{https://docs.octave.org/octave.pdf}. Page 47.
}
}
\seealso{
\code{\link[base]{length}}, \code{\link[base]{lengths}}, \code{\link[pracma]{size}}, \code{\link{size}}
}
\author{
Irucka Embry, Samit Basu (FreeMat)
}
