% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges.R
\encoding{UTF-8}
\name{ranges}
\alias{ranges}
\title{Sample range}
\source{
\enumerate{
   \item r - How to not run an example using roxygen2? - Stack Overflow answered and edited by samkart on Jul 9 2017. (Also see the additional comments in response to the answer.) See \url{https://stackoverflow.com/questions/12038160/how-to-not-run-an-example-using-roxygen2}.
   \item devtools - Issues in R package after CRAN asked to replace dontrun by donttest - Stack Overflow answered by Hong Ooi on Sep 1 2020. (Also see the additional comments in response to the answer.) See \url{https://stackoverflow.com/questions/63693563/issues-in-r-package-after-cran-asked-to-replace-dontrun-by-donttest}.
}
}
\usage{
ranges(x, na.rm = FALSE, finite = FALSE)
}
\arguments{
\item{x}{any numeric vector}

\item{na.rm}{logical vector that determines whether the missing values
should be removed or not. The default is FALSE.}

\item{finite}{logical vector that determines whether non-finite values
should be removed or not. The default is FALSE.}
}
\value{
ranges as the difference between the maximum and minimum values in \code{x}
   as a numeric \code{\link[base]{vector}}. Unlike the \code{\link[base]{range}}, ranges can't
   take character vectors as arguments, only numeric vectors.
}
\description{
This function computes the sample range.
}
\details{
"The range is the difference between the largest number and the smallest
number in the set." Source: Onwubiko page 176.

The following statements are from \code{\link[base]{range}}:

"If na.rm is \code{FALSE}, \code{NA} and \code{NaN} values in any of the
arguments will cause \code{NA} values to be returned, otherwise \code{NA}
values are ignored."

"If finite is \code{TRUE}, the minimum and maximum of all finite values is
computed, i.e., \code{finite = TRUE} includes \code{na.rm = TRUE}."
}
\examples{

# Example 1

install.load::load_package("iemisc", "rando")

set_n(100) # makes the example reproducible

x <- r_norm(.seed = 943)

ranges(x)


install.load::load_package("iemisc", "rando")

set_n(100) # makes the example reproducible

(r.x <- ranges(r_norm(.seed = 100))); r.x


\donttest{
# See Source 1 and Source 2

# Example 2 (from the base range function)

library(iemisc)

xi <- c(NA, 1:3, -1:1/0); xi

try(ranges(xi))

try(ranges(xi, na.rm = TRUE))

try(ranges(xi, finite = TRUE))
}


}
\references{
Chinyere Onwubiko, \emph{An Introduction to Engineering}, Mission, Kansas: Schroff Development Corporation, 1997, page 176.
}
\seealso{
\code{\link{sgm}} for geometric mean, \code{\link{shm}} for harmonic mean, \code{\link{cv}} for
 coefficient of variation (CV), \code{\link{rms}} for root-mean-square (RMS), \code{\link{relerror}}
 for relative error, and \code{\link{approxerror}} for approximate error.
}
\author{
Irucka Embry
}
