% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composite_CN.R
\encoding{UTF-8}
\name{uc_composite_CN}
\alias{uc_composite_CN}
\title{Composite CN (Curve Number) with Unconnected Impervious Area}
\usage{
uc_composite_CN(pervious_CN, impervious, R)
}
\arguments{
\item{pervious_CN}{numeric vector containing the pervious runoff curve number}

\item{impervious}{numeric vector containing the percent imperviousness}

\item{R}{numeric vector containing the ratio of unconnected impervious area to total impervious area}
}
\value{
the Composite Runoff Curve Number as a single numeric vector, in the
  range [0, 100]
}
\description{
This function computes the composite CN (Curve Number) for unconnected
impervious areas and total impervious areas less than 30 percent.
}
\examples{

# Please refer to iemiscdata: Weighted CN Calculations Using the Composite CN
# vignette in the iemiscdata package




}
\references{
United States Department of Agriculture Natural Resources Conservation Service Conservation Engineering Division, "Urban Hydrology for Small Watersheds Technical Release 55 (TR-55)", June 1986, pages 2-11 - 2-16, \url{https://web.archive.org/web/20230810204711/https://directives.sc.egov.usda.gov/OpenNonWebContent.aspx?content=22162.wba} [Recovered with the Internet Archive: Wayback Machine]
}
\author{
Irucka Embry
}
