% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_split.R
\name{sort_split}
\alias{sort_split}
\title{Console-based application to sort and split spatio-temporal chunks of images}
\usage{
sort_split(path, startYear, endYear, nrow_split, ncol_split)
}
\arguments{
\item{path}{character with full path name to a directory containing a set
of files to be split.}

\item{startYear}{numeric indicating the starting time-point, on the annual scale,
of a time series of satellite images.}

\item{endYear}{numeric indicating the ending time-point, on the annual scale,
of a time series of satellite images.}

\item{nrow_split}{numeric, in how many equal parts the images' rows must be split? 
See \bold{Details.}}

\item{ncol_split}{numeric, in how many equal parts the images' cols must be split?
See \bold{Details.}}
}
\value{
When the user decides not to proceed with this function,
a \code{NULL} is returned at the console. 
Otherwise, the resulting splits (.tif files) will be saved at the sub-directories 
defined by \code{paste0(path, "/gapfill/splits")} and a corresponding final _invisible_ 
message is displayed at the console.
}
\description{
An application of \code{\link[geoTS]{split_replace}} to split/divide/configure
images in parts to which a subsequent call of \code{\link[igapfill]{applyGapfill}} 
can be easily handled by regular computer systems.
}
\details{
This function asks the user a series of inputs on-the-fly. Should the user allow it, 
these inputs will be used as arguments in a subsequent call to \code{split_replace}.

\code{\link[igapfill]{create_dirs}} defines a specific directory
structure used by \code{sort_split}, hence, it is highly recommended
to use \code{create_dirs} in advance. Also, it is highly recommended to use 
\code{sort_split} before using \code{\link[igapfill]{applyGapfill}}.
}
\note{
The "sort" part of the function means that in case that the file 
list created from \code{path} is not originally ordered, then \code{sort_split}
will sort it out internally.
}
\seealso{
\code{\link[igapfill]{waysToSplit}}, \code{\link[igapfill]{dimsReport}}, 
\code{\link[geoTS]{split_replace}}.
}
