% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{sample_k_regular}
\alias{sample_k_regular}
\alias{k.regular.game}
\title{Create a random regular graph}
\usage{
sample_k_regular(no.of.nodes, k, directed = FALSE, multiple = FALSE)
}
\arguments{
\item{no.of.nodes}{Integer scalar, the number of vertices in the generated
graph.}

\item{k}{Integer scalar, the degree of each vertex in the graph, or the
out-degree and in-degree in a directed graph.}

\item{directed}{Logical scalar, whether to create a directed graph.}

\item{multiple}{Logical scalar, whether multiple edges are allowed.}
}
\value{
An igraph graph.
}
\description{
Generate a random graph where each vertex has the same degree.
}
\details{
This game generates a directed or undirected random graph where the degrees
of vertices are equal to a predefined constant k. For undirected graphs, at
least one of k and the number of vertices must be even.

The game simply uses \code{\link{sample_degseq}} with appropriately
constructed degree sequences.
}
\examples{

## A simple ring
ring <- sample_k_regular(10, 2)
plot(ring)

## k-regular graphs on 10 vertices, with k=1:9
k10 <- lapply(1:9, sample_k_regular, no.of.nodes=10)

layout(matrix(1:9, nrow=3, byrow=TRUE))
sapply(k10, plot, vertex.label=NA)
}
\seealso{
\code{\link{sample_degseq}} for a generator with prescribed degree
sequence.
}
\author{
Tamas Nepusz \email{ntamas@gmail.com}
}
\keyword{graphs}
