% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{feedback_arc_set}
\alias{feedback_arc_set}
\title{Finding a feedback arc set in a graph}
\usage{
feedback_arc_set(graph, weights = NULL, algo = c("approx_eades", "exact_ip"))
}
\arguments{
\item{graph}{The input graph}

\item{weights}{Potential edge weights. If the graph has an edge
attribute called \sQuote{\code{weight}}, and this argument is
\code{NULL}, then the edge attribute is used automatically. The goal of
the feedback arc set problem is to find a feedback arc set with the smallest
total weight.}

\item{algo}{Specifies the algorithm to use. \dQuote{\code{exact_ip}} solves
the feedback arc set problem with an exact integer programming algorithm that
guarantees that the total weight of the removed edges is as small as possible.
\dQuote{\code{approx_eades}} uses a fast (linear-time) approximation
algorithm from Eades, Lin and Smyth. \dQuote{\code{exact}} is an alias to
\dQuote{\code{exact_ip}} while \dQuote{\code{approx}} is an alias to
\dQuote{\code{approx_eades}}.}
}
\value{
An edge sequence (by default, but see the \code{return.vs.es} option
of \code{\link[=igraph_options]{igraph_options()}}) containing the feedback arc set.
}
\description{
A feedback arc set of a graph is a subset of edges whose removal breaks all
cycles in the graph.
}
\details{
Feedback arc sets are typically used in directed graphs. The removal of a
feedback arc set of a directed graph ensures that the remaining graph is a
directed acyclic graph (DAG). For undirected graphs, the removal of a feedback
arc set ensures that the remaining graph is a forest (i.e. every connected
component is a tree).
}
\examples{

g <- sample_gnm(20, 40, directed = TRUE)
feedback_arc_set(g)
feedback_arc_set(g, algo = "approx")
}
\references{
Peter Eades, Xuemin Lin and W.F.Smyth: A fast and effective
heuristic for the feedback arc set problem. \emph{Information Processing Letters}
47:6, pp. 319-323, 1993
}
\seealso{
Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{degree}()},
\code{\link{dfs}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{girth}()},
\code{\link{is_acyclic}()},
\code{\link{is_dag}()},
\code{\link{is_matching}()},
\code{\link{k_shortest_paths}()},
\code{\link{knn}()},
\code{\link{laplacian_matrix}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{subgraph}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}

Graph cycles
\code{\link{girth}()},
\code{\link{has_eulerian_path}()},
\code{\link{is_acyclic}()},
\code{\link{is_dag}()}
}
\concept{cycles}
\concept{structural.properties}
\keyword{graphs}
