% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{count_imgs}
\alias{count_imgs}
\title{Count the number of images in a TIFF file.}
\usage{
count_imgs(path)
}
\arguments{
\item{path}{A string. The path to the tiff file to read.}
}
\value{
A number.
}
\description{
TIFF files can hold many images. Often this is sensible, e.g. each image
could be a time-point in a video or a slice of a z-stack. Sometimes
ImageJ-written images have one image per channel per slice.
}
\details{
For those familiar with TIFF files, this function counts the number of
directories in a TIFF file.
}
\examples{
count_imgs(system.file("img", "Rlogo.tif", package="ijtiff"))
count_imgs(system.file("img", "2ch_ij.tif", package="ijtiff"))

}
