% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rgb2gray}
\alias{rgb2gray}
\title{RGB to Gray Conversion}
\usage{
rgb2gray(img)
}
\arguments{
\item{img}{3-dimensional array of numeric or integer
values}
}
\value{
A matrix of grayscale values.
}
\description{
\code{rgb2gray} transforms colors from RGB space
(red/green/blue) into an matrix of grayscale values.
}
\details{
The function takes a 3-dimensional array of
  numeric or integer values as input (\code{img}) and
  returns a matrix of grayscale values as output. The
  grayscale values are computed as \code{GRAY = 0.2989 *
  RED + 0.5870 * GREEN + 0.1140 * BLUE}. If the array has
  a fourth dimension (i.e., alpha channel), the fourth
  dimension is ignored.
}
\examples{
# construct a sample RGB image as array of random integers
imgRed <- matrix(runif(100, min = 0, max = 255), 10, 10)
imgGreen <- matrix(runif(100, min = 0, max = 255), 10, 10)
imgBlue <- matrix(runif(100, min = 0, max = 255), 10, 10)
imgColor <- array(c(imgRed, imgGreen, imgBlue), dim = c(10, 10, 3))

# convert to gray
img <- rgb2gray(imgColor)
}
